;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: QP0B.inc
;;   Version: 2.3, Updated on 2004/07/29 at 17:41:18
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for QP0B API's.
;--------------------------------------------------

QP0B_CONTROL_REG_START_BIT:                equ 0x01    ; Control register start bit
QP0B_INT_REG:                              equ 0x0df
QP0B_INT_MASK:                             equ 0x20


;--------------------------------------------------
; Constants for QP0B user defined values
;--------------------------------------------------

QP0B_PERIOD:                               equ 0xff
QP0B_COMPARE_VALUE:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for QP0B
;--------------------------------------------------

QP0B_COUNTER_REG:                      equ 0x54   ; DR0 Counter register
QP0B_PERIOD_REG:                       equ 0x55   ; DR1 Period register
QP0B_COMPARE_REG:                      equ 0x56   ; DR2 CompareValue register
QP0B_CONTROL_REG:                      equ 0x57   ; Control register
QP0B_FUNC_REG:                         equ 0x54   ; Function register
QP0B_INPUT_REG:                        equ 0x55   ; Input register
QP0B_OUTPUT_REG:                       equ 0x56   ; Output register


;--------------------------------------------------
; QP0B Macro 'Functions'
;--------------------------------------------------

   macro QP0B_Start_M
   or    reg[QP0B_CONTROL_REG],  QP0B_CONTROL_REG_START_BIT
   endm

   macro QP0B_Stop_M
   and   reg[QP0B_CONTROL_REG], ~QP0B_CONTROL_REG_START_BIT
   endm

   macro QP0B_EnableInt_M
   M8C_EnableIntMask QP0B_INT_REG, QP0B_INT_MASK
   endm

   macro QP0B_DisableInt_M
   M8C_DisableIntMask QP0B_INT_REG, QP0B_INT_MASK
   endm


; end of file QP0B.inc
